﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Workflow.Activities;



/*  
    WWF Local Communication Services
 
    ExternalDataExchangeService 
    CallExternalMethodActivity
 
    ExternalDataExchangeAttribute
 
 */
namespace Lessons.Workflows
{
    class Program
    {
        static void Main(string[] args)
        {

            using (WorkflowRuntime workflowRuntime = new WorkflowRuntime())
            {
                AutoResetEvent waitHandle = new AutoResetEvent(false);

                workflowRuntime.WorkflowCompleted += delegate(object sender, WorkflowCompletedEventArgs e) { waitHandle.Set(); };
                workflowRuntime.WorkflowTerminated += delegate(object sender, WorkflowTerminatedEventArgs e)
                {
                    Console.WriteLine(e.Exception.Message);
                    waitHandle.Set();
                };

                /* 1. create an ExternalDataExchangeService object   */
                ExternalDataExchangeService ExchangeService = new ExternalDataExchangeService();

                /* 2. register the ExternalDataExchangeService object with the workflowRuntime   */
                workflowRuntime.AddService(ExchangeService);

                /* 3. create an instance of the a WorkflowInfo service.
                   in a real-world situation we may use a parameterized constructor here 
                   in order to pass some info to the WorkflowInfo instance regarding host */
                WorkflowInfo WI = new WorkflowInfo();

                /* 4. register a WorkflowInfo service with the ExternalDataExchangeService object   */
                ExchangeService.AddService(WI);

                WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
                instance.Start();

                waitHandle.WaitOne();

                Console.WriteLine("Hit <ENTER> key to exit");
                Console.ReadLine();
            }
        }
    }
}





namespace Lessons.Workflows
{

    /* the interface used as a contract between workflow host and workflow runtime engine */
    [ExternalDataExchange]
    public interface IWorkflowInfo
    {
        void InformHost(string Text);
    }


    /* a class implementing the contract interface. Only one implementation is allowed */
    public class WorkflowInfo : IWorkflowInfo
    {
        public void InformHost(string Text)
        {
            Console.WriteLine(Text);
        }
    }

}